% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ANVS.R
\name{av_ar1}
\alias{av_ar1}
\title{Calculate Theoretical Allan Variance for Stationary First-Order Autoregressive 
(AR1) Process}
\usage{
av_ar1(n, phi, sigma2)
}
\arguments{
\item{n}{An \code{integer} value for the size of the cluster.}

\item{phi}{A \code{double} value for the autocorrection parameter \eqn{\phi}{phi}.}

\item{sigma2}{A \code{double} value for the variance parameter \eqn{\sigma ^2}{sigma^2}.}
}
\value{
A \code{double} indicating the theoretical allan variance for AR1 process.
}
\description{
This function allows us to calculate the theoretical allan variance for stationary 
first-order autoregressive (AR1) process.
}
\note{
This function is based on the calculation of the theoretical allan variance 
for stationary AR1 process raised in "Allan Variance of Time Series Models for 
Measurement Data" by Nien Fan Zhang.) This calculation
is fundamental and necessary for the study in "A Study of the Allan Variance for Constant-Mean 
Non-Stationary Processes" by Xu et al. (IEEE Signal Processing Letters, 2017).
}
\examples{
av1 = av_ar1(n = 5, phi = 0.9, sigma2 = 1)
av2 = av_ar1(n = 8, phi = 0.5, sigma2 = 2)
}
\author{
Yuming Zhang
}
