% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/census_helper.R
\name{census_helper}
\alias{census_helper}
\title{Census helper function.}
\usage{
census_helper(key, voter.file, states = "all", geo = "tract", age = FALSE,
  sex = FALSE, census.data = NA)
}
\arguments{
\item{key}{A required character object. Must contain user's Census API
key, which can be requested \href{http://api.census.gov/data/key_signup.html}{here}.}

\item{voter.file}{An object of class \code{data.frame}. Must contain field(s) 
named \code{\var{county}}, \code{\var{tract}}, and/or \code{\var{block}} 
specifying geolocation. These should be character variables that match up with 
U.S. Census categories. County should be three characters (e.g., "031" not "31"), 
tract should be six characters, and block should be four characters.}

\item{states}{A character vector specifying which states to extract 
Census data for, e.g. \code{c("NJ", "NY")}. Default is \code{"all"}, which extracts 
Census data for all states contained in user-input data.}

\item{geo}{A character object specifying what aggregation level to use. 
Use \code{"county"}, \code{"tract"}, or \code{"block"}. Default is \code{"tract"}. 
Warning: extracting block-level data takes very long.}

\item{age}{A \code{TRUE}/\code{FALSE} object indicating whether to condition on 
age or not. If \code{FALSE} (default), function will return Pr(Geolocation | Race).
If \code{TRUE}, function will return Pr(Geolocation, Age | Race). 
If \code{\var{sex}} is also \code{TRUE}, function will return Pr(Geolocation, Age, Sex | Race).}

\item{sex}{A \code{TRUE}/\code{FALSE} object indicating whether to condition on 
sex or not. If \code{FALSE} (default), function will return Pr(Geolocation | Race). 
If \code{TRUE}, function will return Pr(Geolocation, Sex | Race). 
If \code{\var{age}} is also \code{TRUE}, function will return Pr(Geolocation, Age, Sex | Race).}

\item{census.data}{A optional census object of class \code{list} containing 
pre-saved Census geographic data. Can be created using \code{get_census_data} function.
If \code{\var{census.data}} is provided, the \code{\var{age}} element must have the same value
as the \code{\var{age}} option specified in this function (i.e., \code{TRUE} in both or 
\code{FALSE} in both). Similarly, the \code{\var{sex}} element in the object provided in 
\code{\var{census.data}} must have the same value as the \code{\var{sex}} option here.
If \code{\var{census.data}} is missing, Census geographic data will be obtained via Census API.}
}
\value{
Output will be an object of class \code{data.frame}. It will 
 consist of the original user-input data with additional columns of 
 Census data.
}
\description{
\code{census_helper} links user-input dataset with Census geographic data.
}
\details{
This function allows users to link their geocoded dataset (e.g., voter file) 
with U.S. Census 2010 data. The function extracts Census Summary File data 
at the county, tract, or block level using the 'UScensus2010' package. Census data 
calculated are Pr(Geolocation | Race) where geolocation is county, tract, or block.
}
\examples{
\dontshow{data(voters)}
\dontrun{census_helper(key = "...", voter.file = voters, states = "nj", geo = "block")}
\dontrun{census_helper(key = "...", voter.file = voters, states = "all", geo = "tract", 
age = TRUE, sex = TRUE)}

}

