% Generated by roxygen2 (4.0.2): do not edit by hand
\name{rfcana}
\alias{rfcana}
\title{rfcana}
\usage{
rfcana(listOfFiles = NULL, optLogFilePath = NULL, beginTime = 0,
  centerTime = FALSE, endTime = 0, windowShift = 5, windowSize = 20,
  effectiveLength = TRUE, window = "BLACKMAN", order = 0,
  preemphasis = -0.95, lpType = "RFC", toFile = TRUE,
  explicitExt = NULL, outputDirectory = NULL,
  forceToLog = useWrasspLogger)
}
\arguments{
\item{listOfFiles}{vector of file paths to be processed by function}

\item{optLogFilePath}{path to option log file}

\item{beginTime}{= <time>: set begin of analysis interval to <time> seconds (default = 0: begin of file)}

\item{centerTime}{set single-frame analysis with the analysis window centred at <time> seconds;
overrules beginTime, endTime and windowShift options}

\item{endTime}{= <time>: set end of analysis interval to <time> seconds (default = 0: end of file)}

\item{windowShift}{= <dur>: set analysis window shift to <dur> ms (default: 5.0)}

\item{windowSize}{= <dur>: set analysis window size to <dur> ms; overrules effectiveLength option}

\item{effectiveLength}{make window size effective rather than exact}

\item{window}{= <type>: set analysis window function to <type> (default: BLACKMAN)}

\item{order}{= <num>: set prediction order to <num> (default: sample rate in kHz + 3)}

\item{preemphasis}{= <val>: set pre-emphasis factor to <val> (default: -0.95)}

\item{lpType}{= <type>: calculate <type> LP parameters; <type> may be:
"ARF": area function
"LAR": log area ratios
"LPC": linear prediction filter coefficients
"RFC": reflection coefficients (default)}

\item{toFile}{write results to file (default extension dependent on LpType .arf/.lar/.lpc/.rfc)}

\item{explicitExt}{set if you wish to overwride the default extension}

\item{outputDirectory}{directory in which output files are stored. Defaults to NULL, i.e.
the directory of the input files}

\item{forceToLog}{is set by the global package variable useWrasspLogger. This is set
to FALSE by default and should be set to TRUE is logging is desired.}
}
\value{
nrOfProcessedFiles or if only one file to process return AsspDataObj of that file
}
\description{
rfcana function adapted from libassp
}
\details{
Linear Prediction analysis of <listOfFiles> using the
autocorrelation method and the Durbin recursion.
This program calculates the RMS amplitudes of the input
and residual signal in dB and, per default, reflection
coefficients (see '-t' option).
Analysis results will be written to a file with the
base name of the input file and the parameter type in
lower case as extension (e.g. '.rfc').
Default output is in SSFF binary format (tracks 'rms',
'gain' and the LP type in lower case).
}
\examples{
# get path to audio file
path2wav <- list.files(system.file("extdata", package = "wrassp"),
                       pattern = glob2rx("*.wav"),
                       full.names = TRUE)[1]

# perform linear prediction analysis
res <- rfcana(path2wav, toFile=FALSE)

# plot reflection coefficients
matplot(seq(0,numRecs.AsspDataObj(res) - 1) / rate.AsspDataObj(res) +
          attr(res, 'startTime'),
        res$rfc,
        type='l',
        xlab='time (s)',
        ylab='reflection coefficient values')
}
\author{
Raphael Winkelmann

Lasse Bombien
}

