% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda.R
\name{makeFunction_se}
\alias{makeFunction_se}
\title{Build an anonymous function.}
\usage{
makeFunction_se(params, body, env = parent.frame())
}
\arguments{
\item{params}{formal parameters of function, unbound names.}

\item{body}{substituted body of function to map arguments into.}

\item{env}{environment to work in.}
}
\value{
user defined function.
}
\description{
Build an anonymous function.
}
\examples{

f <- makeFunction_se(as.name('x'), substitute({x*x}))
f(7)


g <- makeFunction_se(c(as.name('x'), as.name('y')), substitute({ x + 3*y }))
g(1,100)


}
\seealso{
\code{\link{lambda}}, \code{\link{defineLambda}}, \code{\link{named_map_builder}}
}
