% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psagg.R
\name{psagg}
\alias{psagg}
\title{Pseudo aggregator.}
\usage{
psagg(x, ..., strict = TRUE)
}
\arguments{
\item{x}{should be a vector or list of items.}

\item{...}{force later arguments to be passed by name}

\item{strict}{logical, should we check value uniqueness.}
}
\value{
x[[1]] (or throw if not all items are equal or this is an empty vector).
}
\description{
Take a vector or list and return the first element (pseudo-aggregation or projection).
If the argument length is zero or there are different items throw in an error.
}
\details{
This function is useful in some split by column situations as a safe and legible
way to convert vectors to scalars.
}
\examples{

d <- data.frame(
  group = c("a", "a", "b"),
  stringsAsFactors = FALSE)
dl <- lapply(
  split(d, d$group),
  function(di) {
    data.frame(
      # note: di$group is a possibly length>1 vector!
      # pseudo aggregate it to the value that is
      # constant for each group, confirming it is constant.
      group_label = psagg(di$group),
      group_count = nrow(di),
      stringsAsFactors = FALSE
    )
  })
do.call(rbind, dl)

}
