% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/let.R
\name{letprep}
\alias{letprep}
\title{Substitute text.}
\usage{
letprep(alias, strexpr, strict = FALSE)
}
\arguments{
\item{alias}{mapping named list/vector to strings/names or general}

\item{strexpr}{character vector source text to be re-writtin}

\item{strict}{logocal if TRUE only map to non-reserved names}
}
\value{
parsed R expression
}
\description{
Substitute text.
}
\examples{


letprep(alias= list(RankColumn= 'rank', GroupColumn= 'Species'),
    strexpr= '{
       # Notice code here can be written in terms of known or concrete
       # names "RankColumn" and "GroupColumn", but executes as if we
       # had written mapping specified columns "rank" and "Species".

       # restart ranks at zero.
       dres <- d
       dres$RankColumn <- dres$RankColumn - 1 # notice using $ not [[]]

       # confirm set of groups.
       groups <- unique(d$GroupColumn)
    }',
    strict= TRUE)


}
