% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/let.R
\name{let}
\alias{let}
\title{Execute expr with name substitutions specified in alias.}
\usage{
let(alias, expr, strict = TRUE)
}
\arguments{
\item{alias}{mapping from free names in expr to target names to use.}

\item{expr}{block to prepare for execution}

\item{strict}{logical is TRUE restrict map values to non-reserved non-dot names}
}
\value{
result of expr executed in calling environment
}
\description{
\code{let} implements a mapping from desired names (names used directly in the expr code) to names used in the data.
Mnemonic: "expr code symbols are on the left, external data and function argument names are on the right."
}
\details{
Inspired by \code{gtools::strmacro} by Gregory R. Warnes.
Please see the \code{wrapr} \code{vignette} for some discussion of let and crossing function call boundaries: \code{vignette('wrapr','wrapr')}.
Transformation is performed by substitution on the expression parse tree, so be wary of name collisions or aliasing.

Something like \code{let} is only useful to get control of a function that is parameterized
(in the sense it take column names) but non-standard (in that it takes column names from
non-standard evaluation argument name capture, and not as simple variables or parameters).  So  \code{wrapr:let} is not
useful for non-parameterized functions (functions that work only over values such as \code{base::sum}),
and not useful for functions take parameters in straightforward way (such as \code{base::merge}'s "\code{by}" argument).
\code{dplyr::mutate} is an example where
we can use a \code{let} helper.   \code{dplyr::mutate} is
parameterized (in the sense it can work over user supplied columns and expressions), but column names are captured through non-standard evaluation
(and it rapidly becomes unwieldy to use complex formulas with the standard evaluation equivalent \code{dplyr::mutate_}).
\code{alias} can not include the symbol "\code{.}". Except for identity assignments keys and destinations must be disjoint.

The intent from is from the user perspective to have (if
\code{a <- 1; b <- 2}):
\code{let(c(z = 'a'), z+b)} to behave a lot like
\code{eval(substitute(z+b, c(z=quote(a))))}.
}
\examples{

d <- data.frame(Sepal_Length=c(5.8,5.7),
                Sepal_Width=c(4.0,4.4),
                Species='setosa',
                rank=c(1,2))

mapping = list(RankColumn= 'rank', GroupColumn= 'Species')
let(alias=mapping,
    expr={
       # Notice code here can be written in terms of known or concrete
       # names "RankColumn" and "GroupColumn", but executes as if we
       # had written mapping specified columns "rank" and "Species".

       # restart ranks at zero.
       dres <- d
       dres$RankColumn <- dres$RankColumn - 1 # notice using $ not [[]]

       # confirm set of groups.
       groups <- unique(d$GroupColumn)
    })
print(groups)
print(length(groups))
print(dres)

# let works by string substitution aligning on word boundaries,
# so it does (unfortunately) also re-write strings.
let(list(x='y'), 'x')

# let can also substitute arbitrary expressions if strict=FALSE
let(list(e='1+3'), e, strict= FALSE)

}
