% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiMatch.R
\name{multiMatch}
\alias{multiMatch}
\title{Simple Multi-to-Multi Matching of (Concatenated) Terms}
\usage{
multiMatch(
  x,
  y,
  sep = "; ",
  sep2 = NULL,
  method = "matched",
  silent = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{x}{(vector or list) first object to compare; if vector, the (partially) concatenated identifyers (will be split using separator \code{sep}), or list of items to be matched (ie already split)}

\item{y}{(vector or list) second object to compare; if vector, the (partially) concatenated identifyers (will be split using separator \code{sep}), or list of items to be matched (ie already split)}

\item{sep}{(character, length=1) separator used to split concatenated identifyers (if \code{x} or  \code{y} is vector)}

\item{sep2}{(character, length=1) optional separator used when \code{method="matched"} to concatenate all indexes of \code{y} for column \code{y.allInd}}

\item{method}{(character) mode of operation: 'asIndex' to return index of y (those hwo have matches) with names of x (which x are the correpsonding match)}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
list or data.frame (depending on \code{method} chosed)
}
\description{
This function allows convenient matching of multi-to-multi relationships between two objects/vectors. 
It was designed for finding common elements in multiple to multiple matching situations (eg when comparing \code{c("aa; bb", "cc")}  to \code{c("bb; ab","dd")}, 
ie to find 'bb' as matching between both objects).
}
\details{
\code{method='asIndex'} .. returns list (length matches x) where values indicate index of which y is matched by which elment of x (after split). Most concise, but not human reader friendly output.
                                                                                                                                                      
\code{method='matchedL'} .. returns list with IDs (from split of 'x') from x that have been matched to y, names indicate in which y they have been found.
                                                                                                                                                      
\code{method='matched'} .. returns data.frame for all matches in \code{x} with columns:  \code{$matchItem} (not necessarily unique),  \code{$x.ind} (index of x where item has been found),  \code{$x} (value of x), \code{$y.firInd} (first index of y with matched item), \code{y.allInd} (all indexes of y with matched item), \code{y.fir} (full content of first y matched to item).
                                                                                                                                                      
\code{method='adjustXtoY'} .. returns vector with \code{x} adjusted to \code{y}, ie those elements of  \code{x} matching are replace by the exact corresponding term of  \code{y}.
                                                                                                                                                      
If no term matching the terms shown above is given, another version of 'asIndex' is returned, but indexes to \code{y} _after_ spliting by \code{sep}.
}
\examples{
aa <- c("m","k","j; aa","m; aa; bb; o","n; dd","aa","cc")
bb <- c("aa","dd; r","aa; bb; q","p; cc") 
(aOnB <- multiMatch(aa, bb))                        # match aa on bb
(aOnB <- multiMatch(aa, bb, method="matchedL"))     # match aa on bb
(aOnB <- multiMatch(aa, bb, method="asIndex"))      # match aa on bb

}
\seealso{
\code{\link[base]{match}}; \code{\link[base]{strsplit}}
}
