% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extrSpcText.R
\name{extrSpcText}
\alias{extrSpcText}
\title{Extract specific text}
\usage{
extrSpcText(
  txt,
  cutFrom = " GN=",
  cutTo = " PE=",
  missingAs = NA,
  exclFromTag = TRUE,
  silent = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{txt}{character vector to be treated}

\item{cutFrom}{(character) text where to start cutting}

\item{cutTo}{(character) text where to stop cutting}

\item{missingAs}{(character) specific content of output at line/location of 'exclLi'}

\item{exclFromTag}{(logical) to exclude text given in 'cutFrom' from result}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
modified character vector
}
\description{
\code{extrSpcText} extracts/cuts text-fragments out of 'txt' following specific anchors 'cutFrom' and 'cutTo'.
In case 'cutFrom' not found 'missingAs' will be returned.
In case 'cutTo' not found text gets extracted with 'chaMaxEl' characters.
}
\examples{
extrSpcText(c(" ghjg GN=thisText PE=001"," GN=_ PE=",NA,"abcd"))
extrSpcText(c("ABCDEF.3-6","05g","bc.4-5"),cutFr="\\\\.",cutT="-")
}
