% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowNormalize.R
\name{.rowNormFact}
\alias{.rowNormFact}
\title{Obtain normalization factor (main)}
\usage{
.rowNormFact(
  dat,
  combOfN,
  comUse,
  method = "median",
  refLi = NULL,
  refGrp = NULL,
  proportMode = TRUE,
  minQuant = NULL,
  maxFact = 10,
  omitNonAlignable = FALSE,
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{dat}{(matrix) .. init data, smay be parse matrix with numerous NA}

\item{combOfN}{(matrix) ..  # matrix of index for all sub-groups (assumed as sorted)}

\item{comUse}{(list) .. index of complete lines for each col of combOfN}

\item{method}{(character) may be "mean","median" (plus "NULL","none"); When NULL or 'none' is chosen the input will be returned as is}

\item{refLi}{(NULL or numeric) allows to consider only specific lines of 'dat' when determining normalization factors (all data will be normalized)}

\item{refGrp}{(integer) Only the columns indicated will be used as reference, default all columns (integer or colnames)}

\item{proportMode}{(logical) decide if normalization should be done by multiplicative or additive factor}

\item{minQuant}{(numeric) optional filter to set all values below given value as \code{NA}}

\item{maxFact}{(numeric, length=2) max normalization factor}

\item{omitNonAlignable}{(logical) allow omitting all columns which can't get aligned due to sparseness}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) This function allows easier tracking of messages produced}
}
\value{
This function returns a matrix of column-indexes complementing (nCombin rows)
}
\description{
This function was designed to obtain normalization factors.
}
\examples{
ma1 <- matrix(11:41, ncol=3)
}
\seealso{
\code{\link{rowNormalize}}
}
