% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkStrictOrder.R
\name{.scaleSpecGrp}
\alias{.scaleSpecGrp}
\title{Rescale respective to specific group}
\usage{
.scaleSpecGrp(
  x,
  grp1Num,
  grp1Val,
  grp2Num = NULL,
  grp2Val = NULL,
  sumMeth = "mean",
  callFrom = NULL
)
}
\arguments{
\item{x}{(numeric vector) main input}

\item{grp1Num}{(numeric)}

\item{grp1Val}{(numeric)}

\item{grp2Num}{(numeric)}

\item{grp2Val}{(numeric)}

\item{sumMeth}{(character) method for summarizing}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
numeric vector
}
\description{
This function allows to rescale data 'x' so that 2 specific groups get normalized to predefined values (and all other values follow proportionally)
'grp1Num' and 'grp2Num' should be either numeric for positions in 'x' or character for names of 'x';
if 'grp1Num' and/or 'grp2Num' design mulitple locations: perform median or mean summarization, according to 'sumMeth'
}
\examples{
.firstMin(c(4,3:6))
}
\seealso{
\code{\link[base]{which.min}}
}
