% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stableMode.R
\name{stableMode}
\alias{stableMode}
\title{Estimate mode (most frequent value)}
\usage{
stableMode(x, histLike = FALSE, rangeSign = 1:6, nCl = 50,
  callFrom = NULL, silent = FALSE)
}
\arguments{
\item{x}{numeric vector}

\item{histLike}{(logical) if TRUE, will search context dependent, ie like most frequent class of histogram. Using this mode the search will be refined if either 80 percent of values in single class or >50 percent in single}

\item{rangeSign}{(integer) range of numbers used as number of significant values}

\item{nCl}{(integer) defines the number of classes used (if 'histLike'=TRUE), very 'critical' parameter, may change results in strong way !! Note: higher values for 'nCl' will finally loose advantage of histLike-type search of mode !}

\item{callFrom}{(character) allow easier tracking of message(s) produced}

\item{silent}{(logical) suppress messages}
}
\value{
mode value (numeric)
}
\description{
Estimate mode (most frequent value); rounding to range of numbers used as number of significant values ('rangeSign') to better estimate continuous data.
This function uses the package \href{https://CRAN.R-project.org/package=BBmisc}{BBmisc}.
}
\examples{
set.seed(2012); dat <- round(c(rnorm(50),runif(100)),3)
stableMode(dat)
}
\seealso{
\code{\link[base]{cut}}, \code{\link[graphics]{hist}}
}
