% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeSelCol.R
\name{mergeSelCol}
\alias{mergeSelCol}
\title{Merge selected columns out of 2 matrix or data.frames}
\usage{
mergeSelCol(dat1, dat2, selCols, supCols2 = NULL, byC = NULL,
  useAll = FALSE, setRownames = TRUE, newSuff = c(".x", ".y"),
  callFrom = NULL)
}
\arguments{
\item{dat1}{matrix or data.frame for fusing}

\item{dat2}{matrix or data.frame for fusing}

\item{selCols}{will be used to define columns to be used; optionally may be different for 'dat2' : define in 'supCols2'}

\item{supCols2}{if additional column-names should be extracted form dat2}

\item{byC}{(character) 'by' value used in \code{\link[base]{merge}}}

\item{useAll}{(logical) use all lines (will produce NAs when given identifyer not found un 2nd group of data)}

\item{setRownames}{(logical) if TRUE, will use values of col used as 'by' as rownames instead of showing as add'l col in output}

\item{newSuff}{(character) prefix (argument 'suffixes' in \code{merge})}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
data.frame
}
\description{
\code{mergeSelCol} merges selected columns out of 2 matrix or data.frames.
'selCols' will be used to define columns to be used; optionally may be different for 'dat2' : define in 'supCols2'. 
Output-cols will get additions specified in newSuff (default '.x' and '.y')
}
\examples{
mat1 <- matrix(c(1:7,letters[1:7],11:17),ncol=3,dimnames=list(LETTERS[1:7],c("x1","x2","x3")))
mat2 <- matrix(c(1:6,c("b","a","e","f","g","k"),31:36),
  ncol=3,dimnames=list(LETTERS[11:16],c("y1","x2","x3")))
mergeSelCol(mat1,mat2,selC=c("x2","x3"))
}
\seealso{
\code{\link[base]{merge}}, merge 3 data.frames using \code{\link{mergeSelCol3}}
}
