% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convToNum.R
\name{convToNum}
\alias{convToNum}
\title{Convert to numeric}
\usage{
convToNum(x, spaceRemove = TRUE, convert = c(NA, "sparseChar"),
  remove = NULL, euroStyle = TRUE, sciIncl = TRUE, callFrom = NULL,
  silent = TRUE)
}
\arguments{
\item{x}{vector to be converted}

\item{spaceRemove}{(logical) to remove all heading and trailing (white) space (until first non-space character)}

\item{convert}{(character) define which type of non-conform entries to concert to NAs. Note, if \code{remove} is selected to eliminate character-entries they cannot be converted any more. Use 'allChar' for all character-entries; 'sparseChar' sparse (ie rare) character entries; \code{NA} for converting 'Na' or 'na' to \code{NA}; if 'none' or \code{NULL} no conversions at all.}

\item{remove}{(character) define which type of non-conform entries to remove, removed items cannot converted to \code{NA} any more. Use 'allChar' for removing all character entries; \code{NA} for removing all instances of \code{NA} (execept thise created by converting text); all elements will be kept if 'none' or \code{NULL}.}

\item{euroStyle}{(logical) if \code{TRUE} will convert all ',' (eg used as European decimal-separator) to '.' (as internally used by R as decimal-separator), thus allowing converting the European decimal format.}

\item{sciIncl}{(logical) include recognizing scientific notation (eg 2e-4)}

\item{callFrom}{(character) allow easier tracking of message(s) produced}

\item{silent}{(logical) suppress messages}
}
\value{
numeric vector (or matrix (if 'x' is matrix))
}
\description{
\code{convToNum} checks if input vector/character string contains numbers (with or without comma) and attempts converting to numeric.
This functions was designed for extracting the numeric part of character-vectors (or matrix) containing both numbers and character-elements.
Depending on the parameters \code{convert} and \code{remove} text-entries can be converted to NA (in resulting numeric objects) or removed (the number of elements/lines gets reduced, in consequece). 
Note: if 'x' is a matrix, its matrix-dimensions & -names will be preseved.
Note: so far Inf  and -Inf do not get recognized as numeric.
}
\examples{
x1 <- c("+4"," + 5","6","-7"," - 8","1e6","+ 2.3e4","-3E4","- 4E5") 
convToNum(x1,convert=NA,remove=c("allChar",NA))
convToNum(x1,convert=NA,remove=c("allChar",NA),sciIncl=FALSE)
}
\seealso{
\code{\link[base]{numeric}}
}
