% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkForLegLoc.R
\name{checkForLegLoc}
\alias{checkForLegLoc}
\title{Find best place on plot for placing legend}
\usage{
checkForLegLoc(matr, sampleGrp = NULL, showLegend = TRUE)
}
\arguments{
\item{matr}{(matrix, list or data.frame) main data of plot}

\item{sampleGrp}{(character or factor) with this option the text to be displayed in the legend may be taken into consideration for its length}

\item{showLegend}{(logical or character) decide if \code{matr} should be checked for best location; if \code{showLegend} contains any of the standard legend-location designations (eg 'topleft') it will be used in the output}
}
\value{
list with $showL indicating if legend is desired and $loc for the proposition of the best location
}
\description{
This function tries to find the best location for placing a legend of a bivariate plot, ie scatter-plot.
All 4 corners of the data to plot are inspected for the least occupation by data plotted.
}
\examples{
dat1 <- matrix(c(1:5,1,1:5,5),ncol=2)
grp = c("abc","efghijk")
(legLoc <- checkForLegLoc(dat1,grp)) 
legend(legLoc$loc,legend=grp,text.col=2:3,pch=1,cex=0.8)
}
\seealso{
\code{\link[graphics]{legend}}
}
