% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subject_validate_report.R
\name{subject_validate_report}
\alias{subject_validate_report}
\title{Generate Meeting Text Mining report in HTML for Common Exclusion Terms}
\usage{
subject_validate_report(
  data,
  path = "Subject Lines Validation Report",
  timestamp = TRUE,
  keep = 100,
  seed = 100
)
}
\arguments{
\item{data}{A Meeting Query dataset in the form of a data frame.}

\item{path}{Pass the file path and the desired file name, \emph{excluding the file
extension}. For example, \code{"meeting text mining report"}.}

\item{timestamp}{Logical vector specifying whether to include a timestamp in
the file name. Defaults to \code{TRUE}.}

\item{keep}{A numeric vector specifying maximum number of words to keep.}

\item{seed}{A numeric vector to set seed for random generation.}
}
\value{
An HTML report with the same file name as specified in the arguments is
generated in the working directory. No outputs are directly returned by the
function.
}
\description{
This functions creates a text mining report in HTML based on
Meeting Subject Lines for data validation. It scans a meeting query and
highlights meetings with subjects that include common exlusion terms. It is
intended to be used by an analyst to validate raw data before conducting
additional analysis. Returns a HTML report by default.
}
\seealso{
Other Data Validation: 
\code{\link{check_query}()},
\code{\link{extract_hr}()},
\code{\link{flag_ch_ratio}()},
\code{\link{flag_em_ratio}()},
\code{\link{flag_extreme}()},
\code{\link{flag_outlooktime}()},
\code{\link{hr_trend}()},
\code{\link{hrvar_count_all}()},
\code{\link{hrvar_count}()},
\code{\link{identify_churn}()},
\code{\link{identify_holidayweeks}()},
\code{\link{identify_inactiveweeks}()},
\code{\link{identify_nkw}()},
\code{\link{identify_outlier}()},
\code{\link{identify_privacythreshold}()},
\code{\link{identify_query}()},
\code{\link{identify_shifts_wp}()},
\code{\link{identify_shifts}()},
\code{\link{identify_tenure}()},
\code{\link{remove_outliers}()},
\code{\link{standardise_pq}()},
\code{\link{subject_validate}()},
\code{\link{track_HR_change}()},
\code{\link{validation_report}()}

Other Text-mining: 
\code{\link{meeting_tm_report}()},
\code{\link{pairwise_count}()},
\code{\link{subject_validate}()},
\code{\link{tm_clean}()},
\code{\link{tm_cooc}()},
\code{\link{tm_freq}()},
\code{\link{tm_wordcloud}()}

Other Reports: 
\code{\link{IV_report}()},
\code{\link{capacity_report}()},
\code{\link{coaching_report}()},
\code{\link{collaboration_report}()},
\code{\link{connectivity_report}()},
\code{\link{generate_report}()},
\code{\link{meeting_tm_report}()},
\code{\link{read_preamble}()},
\code{\link{validation_report}()},
\code{\link{workpatterns_report}()}
}
\concept{Data Validation}
\concept{Reports}
\concept{Text-mining}
