% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply.R
\name{pull_wos_apply}
\alias{pull_wos_apply}
\title{Run \code{pull_wos} across multiple queries}
\usage{
pull_wos_apply(queries, editions = c("SCI", "SSCI", "AHCI", "ISTP",
  "ISSHP", "BSCI", "BHCI", "IC", "CCR", "ESCI"),
  sid = auth(Sys.getenv("WOS_USERNAME"), Sys.getenv("WOS_PASSWORD")),
  ...)
}
\arguments{
\item{queries}{Vector of queries to issue to the WoS API and pull data for.}

\item{editions}{Web of Science editions to query. Possible values are listed
\href{http://ipscience-help.thomsonreuters.com/wosWebServicesLite/dbEditionsOptionsGroup/databaseEditionsWos.html}{here}.}

\item{sid}{Session identifier (SID). The default setting is to get a fresh
SID each time you query the WoS, via a call to \code{\link{auth}}. However,
you should try to reuse SID values over multiple queries so that you don't
run into the throttling limits placed on new sessions.}

\item{...}{Arguments passed along to \code{\link[httr]{POST}}.}
}
\value{
The same set of data frames that \code{\link{pull_wos}} returns, with
the addition of a data frame named \code{query}. This data frame contains a
mapping of queries to publications that were returned by those queries.
}
\description{
Run \code{pull_wos} across multiple queries
}
\examples{
\dontrun{

queries <- c('TS = "dog welfare"', 'TS = "cat welfare"')
# we can name the queries so that these names appear in the queries data
# frame returned by pull_wos_apply():
names(queries) <- c("dog welfare", "cat welfare")
pull_wos_apply(queries)
}
}
