% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/worms_func.R
\name{wormsaccepted}
\alias{wormsaccepted}
\title{Constructs "accepted_id" column which contains the "AphiaID" of the respective "accepted" taxon}
\usage{
wormsaccepted(x, verbose = TRUE, n_iter = 10)
}
\arguments{
\item{x}{data.frame}

\item{verbose}{be verbose}

\item{n_iter}{maximum search depth. Usually 3 is sufficient. Safety feature for breaking the \code{while} loop}
}
\value{
a data frame.
}
\description{
takes data.frame as output by \code{\link{wormsbynames}} , 
\code{\link{wormsbymatchnames}}, or \code{\link{wormsbyid}} 
and add field "accepted_id" wich contains the "AphiaID" 
of the respective "accepted" taxon
}
\details{
This function helps updating you taxon information and eliminates ambiguity 
because the valid AphiaID is nor neccessary the AphiaID of an accepted taxon. You should run 
\code{\link{wormsconsolidate}} bevorhand to enshure all "accepted" taxons are present.
}
\examples{
## start with IDs that are no longer up to date 
# get the Aphia information
u<-wormsbyid(c(424548,340537))

#recursively retrive information on the taxa they refer to
v<-wormsconsolidate(u)

# what are the currently correct "accepted" taxa? Answer: "accepted_id".
w<-wormsaccepted(v)
w[,c("scientificname","AphiaID","status","valid_AphiaID","valid_name","accepted_id")]


}
