#' Example Data Sets
#'
#' @details Example workflow sets and associated model fits.
#'
#' `two_class_set` and `two_class_res` were generated using the data in the
#' package file `example-data/two-class-set.R`
#'
#' `chi_features_set` and `chi_features_res` were generated using the data in the
#' package file `example-data/chi-features-res.R`. It is meant to approximate
#' the sequence of models built in Section 1.3 of Kuhn and Johnson (2019).
#'
#' @name two_class_set
#' @aliases two_class_set two_class_res
#' @docType data
#' @return Workflow sets.
#' @keywords datasets
#' @references Max Kuhn and Kjell Johnson (2019) _Feature Engineering and
#' Selection_, \url{https://bookdown.org/max/FES/a-more-complex-example.html}
#' @examples
#' data(two_class_set)
#' two_class_set
NULL

#' @name chi_features_set
#' @rdname two_class_set
#' @aliases chi_features_set chi_features_res
#' @docType data
#' @keywords datasets
NULL
