% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leave_var_out_formulas.R
\name{leave_var_out_formulas}
\alias{leave_var_out_formulas}
\title{Create formulas without each predictor}
\usage{
leave_var_out_formulas(formula, data, full_model = TRUE, ...)
}
\arguments{
\item{formula}{A model formula that contains at least two predictors.}

\item{data}{A data frame.}

\item{full_model}{A logical; should the list include the original formula?}

\item{...}{Options to pass to \code{\link[stats:model.frame]{stats::model.frame()}}}
}
\value{
A named list of formulas
}
\description{
From an initial model formula, create a list of formulas that exclude
each predictor.
}
\details{
The new formulas obey the hierarchy rule so that interactions
without main effects are not included (unless the original formula contains
such terms).

Factor predictors are left as-is (i.e., no indicator variables are created).
}
\examples{
data(penguins, package = "modeldata")

leave_var_out_formulas(
   bill_length_mm ~ .,
   data = penguins
)

leave_var_out_formulas(
   bill_length_mm ~ (island + sex)^2 + flipper_length_mm,
   data = penguins
)

leave_var_out_formulas(
   bill_length_mm ~ (island + sex)^2 + flipper_length_mm +
                    I(flipper_length_mm^2),
   data = penguins
)
}
\seealso{
\code{\link[=workflow_set]{workflow_set()}}
}
