% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy.R
\name{tidy.workflow}
\alias{tidy.workflow}
\title{Tidy a workflow}
\usage{
\method{tidy}{workflow}(x, what = "model", ...)
}
\arguments{
\item{x}{An object to be converted into a tidy \code{\link[tibble:tibble]{tibble::tibble()}}.}

\item{what}{A single string. Either \code{"model"} or \code{"recipe"} to select
which part of the workflow to tidy. Defaults to tidying the model.}

\item{...}{Additional arguments to tidying method.}
}
\description{
This is a \code{\link[generics:tidy]{generics::tidy()}} method for a workflow that calls \code{tidy()} on
either the underlying parsnip model or the recipe, depending on the value
of \code{what}.

\code{x} must be a fitted workflow, resulting in fitted parsnip model or prepped
recipe that you want to tidy.
}
\details{
To tidy the unprepped recipe, use \code{\link[=pull_workflow_preprocessor]{pull_workflow_preprocessor()}} and \code{tidy()}
that directly.
}
