% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wflow_run.R
\name{wflow_run}
\alias{wflow_run}
\title{Run the code}
\usage{
wflow_run(file = NULL, verbose = TRUE, project = ".")
}
\arguments{
\item{file}{character (default: \code{NULL}). The R Markdown file to execute.
Must have file extension Rmd or rmd. If \code{NULL}, the most recently
modified Rmd file will be executed.}

\item{verbose}{logical (default: \code{TRUE}). Should the lines of code (and
their output) be echoed in the R console as they are executed? This
argument is passed directly to the argument \code{echo} of the function
\code{\link{source}}.}

\item{project}{character (default: ".") By default the function assumes the
current working directory is within the project. If this is not true,
you'll need to provide the path to the project directory.}
}
\value{
Invisibly returns the path to the Rmd file that was executed
}
\description{
\code{wflow_run} executes the code chunks of an R Markdown file in the
current R session without affecting any of the website files. This is meant
to be used while interactively developing an analysis. It does not change the
working directory or isolate the computation from the current R session. This
is analogous to the RStudio option "Run all" to run all the code chunks. Use
\code{\link{wflow_publish}} when you are ready to add the results to the
website.
}
\examples{
\dontrun{

# Run the most recently modified Rmd file
wflow_run()
# Run a specific Rmd file
wflow_run("analysis/file.Rmd")
}

}
\seealso{
\code{\link{wflow_build}} with argument \code{local = TRUE},
  \code{\link{source}} with argument \code{echo = TRUE}
}
