% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise_boots.R
\name{summarise_importance}
\alias{summarise_importance}
\alias{summarize_importance}
\title{Append a tibble of variable importances returned by \code{vi_boots()} with upper
and lower bounds.}
\usage{
summarise_importance(.data, interval_width = 0.95, conf = NULL)

summarize_importance(.data, interval_width = 0.95, conf = NULL)
}
\arguments{
\item{.data}{a tibble of variable importances returned by \code{vi_boots()}.}

\item{interval_width}{a value between (0, 1) specifying the interval range.}

\item{conf}{deprecated - please use \code{interval_width} instead.}
}
\description{
Append a tibble of variable importances returned by \code{vi_boots()} with upper
and lower bounds.
}
\details{
Generates a summary of variable importances with an upper and lower
interval range. Uses the \code{vi()} function from the \code{{vip}} package to compute
variable importances (not all model types are supported by \code{vip::vi()}; please
refer to \code{{vip}} package documentation for supported model types). Presently,
the \code{quantile()} function from the \code{{stats}} package is used to determine
the lower, 50th percentile, and upper interval ranges.
}
\examples{
\dontrun{
library(tidymodels)

# setup a workflow without fitting
wf <-
  workflow() \%>\%
  add_recipe(recipe(qsec ~ wt, data = mtcars)) \%>\%
  add_model(linear_reg())

# evaluate variable importance from 2000 models fit to mtcars
set.seed(123)
importances <-
  wf \%>\%
  vi_boots(n = 2000, training_data = mtcars, new_data = mtcars)

# append with lower and upper bound importance summary columns
importances \%>\%
  summarise_importance(interval_width = 0.95)
}
}
