% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tokenization.R
\name{wordpiece_tokenize}
\alias{wordpiece_tokenize}
\title{Tokenize Sequence with Word Pieces}
\usage{
wordpiece_tokenize(text, vocab, unk_token = "[UNK]", max_chars = 100)
}
\arguments{
\item{text}{Character scalar; text to tokenize.}

\item{vocab}{Named integer vector containing vocabulary words}

\item{unk_token}{Token to represent unknown words.}

\item{max_chars}{Maximum length of word recognized.}
}
\value{
A named integer vector, giving the tokenization of the input
sequence. The integers values are the token ids, and the names are the
tokens.
}
\description{
Given a single sequence of text and a wordpiece vocabulary, tokenizes the
text.
}
\examples{
# Get path to sample vocabulary included with package.
vocab_path <- system.file("extdata", "tiny_vocab.txt", package = "wordpiece")
vocab <- load_or_retrieve_vocab(vocab_file = vocab_path, use_cache = FALSE)
tokens <- wordpiece_tokenize(
  text = "I love tacos!",
  vocab = vocab
)
}
