/*
 * Decompiled with CFR 0.152.
 */
package com.nexagis.jawbone;

public final class PartOfSpeech {
    private static final char NOUN_CHAR = 'n';
    private static final char VERB_CHAR = 'v';
    private static final char ADJECTIVE_CHAR = 'a';
    private static final char ADJECTIVE_SATELLITE_CHAR = 's';
    private static final char ADVERB_CHAR = 'r';
    private static final byte NOUN_PREFIX = 1;
    private static final byte VERB_PREFIX = 2;
    private static final byte ADJECTIVE_PREFIX = 3;
    private static final byte ADVERB_PREFIX = 4;
    public static final PartOfSpeech NOUN = new PartOfSpeech("noun", 'n', 1);
    public static final PartOfSpeech VERB = new PartOfSpeech("verb", 'v', 2);
    public static final PartOfSpeech ADJECTIVE = new PartOfSpeech("adj", 'a', 3);
    public static final PartOfSpeech ADJECTIVE_SATELLITE = new PartOfSpeech("adj sat", 's', 3);
    public static final PartOfSpeech ADVERB = new PartOfSpeech("adv", 'r', 4);
    private String key = null;
    private char shortKey = '\u0000';
    private byte prefix = (byte)-1;

    private PartOfSpeech() {
    }

    private PartOfSpeech(String string, char c, byte by) {
        this.key = string;
        this.shortKey = c;
        this.prefix = by;
    }

    public String getKey() {
        return this.key;
    }

    public char getShortKey() {
        return this.shortKey;
    }

    public byte getPrefix() {
        return this.prefix;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof PartOfSpeech)) {
            return false;
        }
        PartOfSpeech partOfSpeech = (PartOfSpeech)object;
        return this.key.equals(partOfSpeech.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return this.key;
    }

    protected static boolean equals(char c, PartOfSpeech partOfSpeech) {
        return partOfSpeech.getShortKey() == c;
    }

    public static PartOfSpeech getInstance(char c) {
        switch (c) {
            case 'n': {
                return NOUN;
            }
            case 'v': {
                return VERB;
            }
            case 'a': {
                return ADJECTIVE;
            }
            case 's': {
                return ADJECTIVE_SATELLITE;
            }
            case 'r': {
                return ADVERB;
            }
        }
        throw new RuntimeException("Unknown type of part of speech: " + Character.toString(c));
    }
}

