% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/github.R
\name{git_update}
\alias{git_update}
\title{Add, commit, and push changes.}
\usage{
git_update(
  message = paste0("update ", Sys.time()),
  files = ".",
  repo = ".",
  author,
  committer,
  remote,
  refspec,
  password,
  ssh_key,
  mirror,
  force,
  verbose
)
}
\arguments{
\item{message}{a commit message}

\item{files}{vector of paths relative to the git root directory. Use "." to stage all changed files.}

\item{repo}{a path to an existing repository, or a git_repository object as returned by git_open, git_init or git_clone.}

\item{author}{A git_signature value, default is git_signature_default.}

\item{committer}{A git_signature value, default is same as author}

\item{remote}{name of a remote listed in git_remote_list()}

\item{refspec}{string with mapping between remote and local refs}

\item{password}{a string or a callback function to get passwords for authentication or password protected ssh keys. Defaults to askpass which checks getOption('askpass').}

\item{ssh_key}{path or object containing your ssh private key. By default we look for keys in ssh-agent and credentials::ssh_key_info.}

\item{mirror}{use the --mirror flag}

\item{force}{use the --force flag}

\item{verbose}{display some progress info while downloading}
}
\value{
No return value. This function is called for its side effects.
}
\description{
This function is a wrapper for
\code{\link[gert]{git_add}}, \code{\link[gert]{git_commit}}, and
\code{\link[gert]{git_push}}. It adds all locally changed files to the
staging area of the local 'Git' repository, then commits these changes
(with an optional) \code{message}, and then pushes them to a remote
repository. This is used for making a "cloud backup" of local changes.
Do not use this function when working with privacy sensitive data,
or any other file that should not be pushed to a remote repository.
The \code{\link[gert]{git_add}} argument \code{force} is disabled by default,
to avoid accidentally committing and pushing a file that is listed in
\code{.gitignore}.
}
\examples{
git_update()
}
