% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/problems.R
\name{wkb_problems}
\alias{wkb_problems}
\alias{wkt_problems}
\alias{wksxp_problems}
\title{Validate well-known binary and well-known text}
\usage{
wkb_problems(wkb)

wkt_problems(wkt)

wksxp_problems(wksxp)
}
\arguments{
\item{wkb}{A \code{list()} of \code{\link[=raw]{raw()}} vectors, such as that
returned by \code{sf::st_as_binary()}.}

\item{wkt}{A character vector containing well-known text.}

\item{wksxp}{A \code{list()} of classed objects}
}
\value{
A character vector of parsing errors. \code{NA} signifies
that there was no parsing error.
}
\description{
Validate well-known binary and well-known text
}
\examples{
# well-known text
wkt_problems(c("POINT EMTPY", "POINT (20 30)"))

# well-known binary
wkb <- wkt_translate_wkb("POINT (30 10)", endian = 1)[[1]]
wkb_bad <- wkb
wkb_bad[2] <- as.raw(255)
wkb_problems(list(wkb, wkb_bad))

}
