% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wksxp.R
\name{wksxp}
\alias{wksxp}
\alias{as_wksxp}
\alias{as_wksxp.character}
\alias{as_wksxp.wk_wksxp}
\alias{as_wksxp.wk_wkt}
\alias{as_wksxp.wk_wkb}
\title{Mark lists as well-known "S" expressions}
\usage{
wksxp(x)

as_wksxp(x, ...)

\method{as_wksxp}{character}(x, ...)

\method{as_wksxp}{wk_wksxp}(x, ..., include_z = NULL, include_m = NULL, include_srid = NULL)

\method{as_wksxp}{wk_wkt}(x, ..., include_z = NULL, include_m = NULL, include_srid = NULL)

\method{as_wksxp}{wk_wkb}(x, ..., include_z = NULL, include_m = NULL, include_srid = NULL)
}
\arguments{
\item{x}{A \code{\link[=list]{list()}} features (see details)}

\item{...}{Unused}

\item{include_z}{Include the
values of the Z and M coordinates and/or SRID
in the output? Use \code{FALSE} to omit, \code{TRUE} to include, or \code{NA} to include
only if present. Note that using \code{TRUE} may result in an error if there
is no value present in the original.}

\item{include_m}{Include the
values of the Z and M coordinates and/or SRID
in the output? Use \code{FALSE} to omit, \code{TRUE} to include, or \code{NA} to include
only if present. Note that using \code{TRUE} may result in an error if there
is no value present in the original.}

\item{include_srid}{Include the
values of the Z and M coordinates and/or SRID
in the output? Use \code{FALSE} to omit, \code{TRUE} to include, or \code{NA} to include
only if present. Note that using \code{TRUE} may result in an error if there
is no value present in the original.}
}
\value{
A \code{\link[=new_wk_wksxp]{new_wk_wksxp()}}
}
\description{
Mark lists as well-known "S" expressions
}
\details{
The "wksxp" format is experimental, but was written as a way to
make it possible for packages to generate \code{\link[=wkb]{wkb()}} vectors without
needing to know C++. The format represents geometries as following:
\itemize{
\item points are matrices with zero or one row
\item linestrings are matrices (one row per point)
\item polygons are lists of matrices (one matrix per ring)
\item multi (point, linestring, polygon) types are lists
of the simple types (without any meta information)
\item collections are lists of any type (must contain meta)
}

Any geometry that isn't in a multi type must have meta information
encoded as attributes. The attribures that are used are:
\itemize{
\item \code{class}: "wk_(point|linestring|...)
\item \code{has_z}: use \code{TRUE} if there is a Z coordinate
(may be omitted if false)
\item \code{has_m}: use \code{TRUE} if there is an M coordinate
(may be omitted if false)
}

This is similar to the \code{\link[sf:sfc]{sf::sfc()}} format, but the formats aren't
interchangable.
}
\examples{
wksxp(wkt_translate_wksxp("POINT (20 10)"))

}
