% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid_area.R
\name{hexa_area}
\alias{hexa_area}
\title{Polygon to Hexagonal Grids}
\usage{
hexa_area(shape, size = 500, plotGrid = FALSE)
}
\arguments{
\item{shape}{Simple Feature Polygon of the considered area}

\item{size}{The cellsize of the grid in meters. Default is 500}

\item{plotGrid}{Logical value indicating whether the results should be
plotted. Default is \code{FALSE}}
}
\value{
Returns a list with 2 elements. List element 1 will have the grid
cell IDS, and the X and Y coordinates of the centers of each grid cell.
List element 2 is the grid as Simple Feature Polygons, which is used for
plotting purposes.
}
\description{
The function takes a Simple Feature Polygon and a size argument
and creates a list with an indexed matrix with coordinates and a
Simple Feature object, that consists of hexagonal grids.
}
\examples{
library(sf)
## Exemplary input Polygon with 2km x 2km:
Poly <- sf::st_as_sf(sf::st_sfc(
  sf::st_polygon(list(cbind(
    c(4498482, 4498482, 4499991, 4499991, 4498482),
    c(2668272, 2669343, 2669343, 2668272, 2668272)
  ))),
  crs = 3035
))
HexGrid <- hexa_area(Poly, 100, TRUE)

}
\seealso{
Other Helper Functions: 
\code{\link{get_grids}()},
\code{\link{grid_area}()},
\code{\link{isSpatial}()},
\code{\link{permutations}()},
\code{\link{readinteger}()},
\code{\link{readintegerSel}()},
\code{\link{splitAt}()},
\code{\link{windata_format}()}
}
\concept{Helper Functions}
