% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetTO.r
\name{GetTO}
\alias{GetTO}
\title{Get period where two tracks overlap}
\usage{
GetTO(traj1, traj2, tc = 0)
}
\arguments{
\item{traj1}{an object of the class \code{ltraj} which contains the time-stamped
movement fixes of the first object. Note this object must be a \code{type II
ltraj} object. For more information on objects of this type see \code{help(ltraj)}.}

\item{traj2}{same as \code{traj1}.}

\item{tc}{time threshold for considering if fixes are in the overlap period.}
}
\value{
A single ltraj object containing two bursts, representing the two original \code{ltraj} 
objects, each containing only those fixes that are overlap in time.
}
\description{
The function \code{GetTemporalOverlap} identifies and extracts parts of a trajectory that overlap in time with another trajectory.
}
\details{
This function is used to determine the fixes that overlap in time between two trajectories.
}
\examples{
data(deer)
deer37 <- deer[1]
deer38 <- deer[2]
trajs <- GetTO(deer37, deer38)
deer37 <- trajs[1]
deer38 <- trajs[2]

}
\seealso{
checkTO
}
\keyword{processing}
