% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wiki_utils.R
\name{w_EntityInfo}
\alias{w_EntityInfo}
\title{Get some personal properties of one Wikidata entity}
\usage{
w_EntityInfo(
  entity,
  langsorder = "en",
  wikilangs = "",
  format = "reduced",
  mode = c("default", "tiny", "film")
)
}
\arguments{
\item{entity}{The Wikidata entity to search for properties. Only one entity
is allowed.}

\item{langsorder}{Order of languages in which the information will be
returned, separated with '|'. If no information exists in the first language,
next is used. This parameter is mandatory, at least one language is required,
default, 'en'.
Note: sometimes not label in any language of langsorder is assigned to an
entity, so an additional search is used to obtain almost one label for it
(?entitylab) with LIMIT 1.}

\item{wikilangs}{List of languages to limit the search of Wikipedia pages,fi
using "|" as separator. Wikipedias pages are returned in same order as
languages in this parameter. If wikilangs='' the function returns Wikipedia
pages in any language, not sorted.}

\item{format}{Wikipedia address format. By default is reduced, Otherwise, format is regular.}

\item{mode}{The mode to obtain results: 'tiny' less properties are requested
and less checks are done; 'film' gets some properties of the Wikidata
"entity" related to information about film ('default' by default).}
}
\value{
A data-frame with the properties of the entity.
}
\description{
Gets some properties of the Wikidata "entity" related to birth and death
dates, places, occupations, works, education, awards, identifier in some
libraries, Wikipedia page titles (which can be limited to the languages in
the "wikilangs" parameter), etc.
}
\examples{
df1 <- w_EntityInfo(entity='Q134644', langsorder = 'es|en')
df2 <- w_EntityInfo(entity='Q134644', langsorder = 'es|en', mode = 'tiny')
\dontrun{
films <- w_EntityInfo(entity=c('Q180098','Q151895'), langsorder='es|en',
wikilangs='es|fr|en', mode='film')
}
}
\author{
Angel Zazo, Department of Computer Science and Automatics, University of Salamanca
}
