% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wikiTools.R
\name{urltoHtml}
\alias{urltoHtml}
\title{Convert a Wikipedia URL to an HTML link}
\usage{
urltoHtml(url, text = NULL)
}
\arguments{
\item{url}{Character vector of URLs.}

\item{text}{A vector with name of the correspondent title of the url (See details).}
}
\value{
A character vector of HTML links for the given urls.
}
\description{
Convert a Wikipedia URL to an HTML link
}
\details{
This function converts an available URL direction to the corresponding HTML link, i.e., "https://es.wikipedia.org/wiki/Socrates" changes into "<a href='https://es.wikipedia.org/wiki/Socrates', target='_blank'>Socrates</a>".
}
\examples{
## When you have a single URL:

urltoHtml("https://es.wikipedia.org/wiki/Socrates", text = "Socrates")

## It is possible to work with several items:

A <- c("https://es.wikipedia.org/wiki/Socrates", 
       "https://es.wikipedia.org/wiki/Plato", 
       "https://es.wikipedia.org/wiki/Aristotle")
urltoHtml (A, text = c("Socrates", "Plato", "Aristotle"))

## And  you can also directly extract the info from nametoWikiURL():

urltoHtml(nametoWikiURL("Plato", "en"), "Plato" )
urltoHtml(nametoWikiURL(c("Plato", "Socrates", "Aristotle"), language="en"), 
          c("Plato", "Socrates", "Aristotle"))
}
\author{
Modesto Escobar, Department of Sociology and Communication, University of Salamanca. See \url{https://sociocav.usal.es/blog/modesto-escobar/}
}
