% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wikiTools.R
\name{urltoFrame}
\alias{urltoFrame}
\title{Convert an URL link to an HTML iframe.}
\usage{
urltoFrame(url)
}
\arguments{
\item{url}{Character vector of URLs.}
}
\value{
A character vector of HTML iframe for the given urls.
}
\description{
Convert an URL link to an HTML iframe.
}
\details{
This function converts an available URL direction to the corresponding HTML iframe, i.e., "https://es.wikipedia.org/wiki/Socrates" changes into "<a href='https://es.wikipedia.org/wiki/Socrates', target='_blank'>Socrates</a>".
}
\examples{
## When you have a single URL:

urltoFrame("https://es.wikipedia.org/wiki/Socrates")

## It is possible to work with a vector of URL to obtain another vector of html frames:

A <- c("https://es.wikipedia.org/wiki/Socrates", 
       "https://es.wikipedia.org/wiki/Plato", 
       "https://es.wikipedia.org/wiki/Aristotle")
urltoHtml (A)
}
\author{
Modesto Escobar, Department of Sociology and Communication, University of Salamanca. See \url{https://sociocav.usal.es/blog/modesto-escobar/}
}
