% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wiki_utils.R
\name{Wikimedia_page_views}
\alias{Wikimedia_page_views}
\title{Wikimedia_page_views
Return the number of views one article has in a Wikimedia project in a date interval (see granularity). Optionally include redirections to the article page.
req_wikimeida_metrics_rated
The limitratedr version of req_wikimedia_metrics.}
\usage{
Wikimedia_page_views(
  article,
  project = "en.wikipedia.org",
  start,
  end,
  access = "all-access",
  agent = "user",
  granularity = "monthly",
  include_redirects = FALSE
)
}
\arguments{
\item{article}{The article to search}

\item{project}{The Wikimedia project, defaults en.wikipedia.org}

\item{start, end}{First and last day to include (format YYYYMMDD or YYYYMMDDHH)}

\item{access}{Filter by access method: all-access (default), desktop, mobile-app, mobile-web}

\item{agent}{Filter by agent type: all-agents, user (default), spider, automated}

\item{granularity}{Time unit for the response data: daily, monthly (default)}

\item{include_redirects}{Boolean to include redirection to the article page (defaults: False)}
}
\value{
The number of visits
}
\description{
Wikimedia_page_views
Return the number of views one article has in a Wikimedia project in a date interval (see granularity). Optionally include redirections to the article page.
req_wikimeida_metrics_rated
The limitratedr version of req_wikimedia_metrics.
}
\author{
Angel F. Zazo, Departament of Computer Science and Automatics, University of Salamanca
}
