% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fig_LID.R
\name{fig_LID}
\alias{fig_LID}
\title{Print a graph showing significant correlations between survey items}
\usage{
fig_LID(
  LIDforgraph,
  LIDcutoff = 0.2,
  path_output,
  extra_file_label = NULL,
  vertex_print_grey = NULL
)
}
\arguments{
\item{LIDforgraph}{a square matrix of item correlations}

\item{LIDcutoff}{a numeric value between 0 and 1 for the cut-off for significant correlation}

\item{path_output}{a string with the path to the output folder}

\item{extra_file_label}{a string to tack on to the end of names of files outputted and the title of the plot. Default is NULL.}

\item{vertex_print_grey}{a character vector with the names of vertices to print in \code{"lightgrey"}, with all others printed in \code{"skyblue"}. If left as default NULL, all vertices will be printed in \code{"lightgrey"}.}
}
\value{
Returns a ggplot graph showing the items with correlation > \code{LIDcutoff} and prints a csv of the corresponding correlations
}
\description{
Print a graph showing significant correlations between survey items
}
\details{
This function could be applied to visualize any kind of correlations. But within the context of the Rasch Analysis used for the WHO Model Disability Survey, the  residual correlations are used when analyzing item dependence.
}
\seealso{
Other figure functions: 
\code{\link{fig_density}()},
\code{\link{fig_dist}()},
\code{\link{fig_poppyramid}()}
}
\concept{figure functions}
