% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_analysis.R
\name{wbt_ihs_to_rgb}
\alias{wbt_ihs_to_rgb}
\title{Ihs to rgb}
\usage{
wbt_ihs_to_rgb(
  intensity,
  hue,
  saturation,
  red = NULL,
  green = NULL,
  blue = NULL,
  output = NULL,
  wd = NULL,
  verbose_mode = FALSE,
  compress_rasters = FALSE,
  command_only = FALSE
)
}
\arguments{
\item{intensity}{Input intensity file.}

\item{hue}{Input hue file.}

\item{saturation}{Input saturation file.}

\item{red}{Output red band file. Optionally specified if colour-composite not specified.}

\item{green}{Output green band file. Optionally specified if colour-composite not specified.}

\item{blue}{Output blue band file. Optionally specified if colour-composite not specified.}

\item{output}{Output colour-composite file. Only used if individual bands are not specified.}

\item{wd}{Changes the working directory.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool.}
}
\value{
Returns the tool text outputs.
}
\description{
Converts intensity, hue, and saturation (IHS) images into red, green, and blue (RGB) images.
}
\keyword{ImageProcessingTools}
