% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terrain_analysis.R
\name{feature_preserving_denoise}
\alias{feature_preserving_denoise}
\title{Feature preserving denoise}
\usage{
feature_preserving_denoise(dem, output, filter = 11, norm_diff = 15,
  num_iter = 10, max_diff = 2, zfactor = 1, verbose_mode = FALSE)
}
\arguments{
\item{dem}{Input raster DEM file.}

\item{output}{Output raster file.}

\item{filter}{Size of the filter kernel.}

\item{norm_diff}{Maximum difference in normal vectors, in degrees.}

\item{num_iter}{Number of iterations.}

\item{max_diff}{Maximum allowable absolute elevation change (optional).}

\item{zfactor}{Optional multiplier for when the vertical and horizontal units are not the same.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is False, tools will not print output messages.}
}
\value{
Returns the tool text outputs.
}
\description{
Reduces short-scale variation in an input DEM using a modified Sun et al. (2007) algorithm.
}
