% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/code_names.R
\name{add_area_code}
\alias{add_area_code}
\title{Get area codes from area names}
\usage{
add_area_code(table, name_column = "area_name", code_column = "area_code")
}
\arguments{
\item{table}{The table that will be modified with a new column.}

\item{name_column}{The name of the column in \code{table} containing the names.}

\item{code_column}{The name of the output column containing the codes.}
}
\value{
A tibble with all the contents of \code{table} and an extra column
named \code{code_column}, which contains the codes. If there is no code match,
an \code{NA} is included.
}
\description{
Add a new column to an existing tibble with the corresponding code
for each name. The codes are assumed to be from those defined by
the \code{FABIO} model.
}
\examples{
table <- tibble::tibble(
  area_name = c("Armenia", "Afghanistan", "Dummy Country", "Albania")
)

add_area_code(table)

table |>
  dplyr::rename(my_area_name = area_name) |>
  add_area_code(name_column = "my_area_name")

add_area_code(table, code_column = "my_custom_code")
}
