% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wkb.R
\name{wkb}
\alias{wkb}
\alias{wkt_wkb}
\alias{wkb_wkt}
\title{Convert WKT to WKB}
\usage{
wkt_wkb(x, ...)

wkb_wkt(x, ...)
}
\arguments{
\item{x}{For \code{wkt_wkb()}, a \code{character} string representing a WKT object;
for \code{wkb_wkt()}, an of class \code{raw} representing a WKB object}

\item{...}{arguments passed on to \code{\link[wk:deprecated]{wk::wkt_translate_wkb()}} or
\code{\link[wk:deprecated]{wk::wkb_translate_wkt()}}}
}
\value{
\code{wkt_wkb} returns an object of class \code{raw}, a WKB
reprsentation. \code{wkb_wkt} returns an object of class \code{character},
a WKT representation
}
\description{
Convert WKT to WKB
}
\examples{
# WKT to WKB
## point
wkt_wkb("POINT (-116.4 45.2)")

## linestring
wkt_wkb("LINESTRING (-116.4 45.2, -118.0 47.0)")

## multipoint
### only accepts the below format, not e.g., ((1 2), (3 4))
wkt_wkb("MULTIPOINT (100.000 3.101, 101.00 2.10, 3.14 2.18)")

## polygon
wkt_wkb("POLYGON ((100.0 0.0, 101.1 0.0, 101.0 1.0, 100.0 0.0))")

# WKB to WKT
## point
(x <- wkt_wkb("POINT (-116.4 45.2)"))
wkb_wkt(x)

## linestring
(x <- wkt_wkb("LINESTRING (-116.4 45.2, -118.0 47.0)"))
wkb_wkt(x)

## multipoint
(x <- wkt_wkb("MULTIPOINT (100.000 3.101, 101.00 2.10, 3.14 2.18)"))
wkb_wkt(x)

## polygon
(x <- wkt_wkb("POLYGON ((100.0 0.0, 101.1 0.0, 101.0 1.0, 100.0 0.0))"))
wkb_wkt(x)
}
