% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lof_scores.R
\name{lof_scores}
\alias{lof_scores}
\title{Local outlier factors}
\usage{
lof_scores(y, k = 10, ...)
}
\arguments{
\item{y}{Numerical matrix or vector of data}

\item{k}{Number of neighbours to include. Default: 5.}

\item{...}{Additional arguments passed to \code{dbscan::\link[dbscan]{lof}}}
}
\value{
Numerical vector containing LOF values
}
\description{
Compute local outlier factors using k nearest neighbours. A local
outlier factor is a measure of how anomalous each observation is based on
the density of neighbouring points.
The function uses \code{dbscan::\link[dbscan]{lof}} to do the calculation.
}
\examples{
y <- c(rnorm(49), 5)
lof_scores(y)
}
\seealso{
\code{dbscan::\link[dbscan]{lof}}
}
\author{
Rob J Hyndman
}
