% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/audience_networks.R
\name{audience_network}
\alias{audience_network}
\title{Create audience networks}
\usage{
audience_network(wt, mode2 = "domain", cutoff = 3, type = "pmi", alpha = 0.05)
}
\arguments{
\item{wt}{webtrack data object}

\item{mode2}{character. name of column that includes the second mode (e.g.
'domain' or 'host')}

\item{cutoff}{visits below this cutoff will not be considered as a visit}

\item{type}{one of "pmi", "phi", "disparity", "sdsm, "or "fdsm".}

\item{alpha}{significance level}
}
\value{
audience network as igraph object
}
\description{
audience network
}
\examples{
\dontrun{
data("testdt_tracking")
wt <- as.wt_dt(testdt_tracking)
wt <- add_duration(wt)
wt <- suppressWarnings(extract_domain(wt))
network <- audience_network(wt, type = "pmi", cutoff = 120)
}
}
