% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tem.R
\name{subset_tem}
\alias{subset_tem}
\title{Subset template points}
\usage{
subset_tem(stimuli, ..., keep = TRUE)
}
\arguments{
\item{stimuli}{list of stimuli}

\item{...}{vectors of points to keep or delete}

\item{keep}{logical; whether to keep or delete the points}
}
\value{
stimlist with altered templates
}
\description{
Keep or delete specified template points. Points will be renumbered and line definitions will be updated. If all points in a line are deleted, the line will be removed. POint indexing is 0-based, so the first two points (usually the pupils) are 0 and 1.
}
\examples{
# keep just the first two points
demo_stim(1) |>
  subset_tem(0:1) |>
  draw_tem(pt.size = 10)

# remove the last 10 points 
# (produces the 179-point Perception Lab template)
demo_stim(1) |>
  subset_tem(179:188, keep = FALSE) |>
  draw_tem()

# use features() to keep only points from a pre-defined set 
# "gmm" is points used for geometric morphometrics
demo_stim(1) |>
  subset_tem(features("gmm")) |>
  draw_tem()

}
\seealso{
Template functions
\code{\link{auto_delin}()},
\code{\link{average_tem}()},
\code{\link{centroid}()},
\code{\link{change_lines}()},
\code{\link{delin}()},
\code{\link{draw_tem}()},
\code{\link{features}()},
\code{\link{get_point}()},
\code{\link{remove_tem}()},
\code{\link{require_tems}()},
\code{\link{same_tems}()},
\code{\link{squash_tem}()},
\code{\link{tem_def}()},
\code{\link{viz_tem_def}()}
}
\concept{tem}
