% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patch.R
\name{patch}
\alias{patch}
\title{Patch colour}
\usage{
patch(
  stimuli,
  width = 10,
  height = 10,
  x_off = 0,
  y_off = 0,
  color = c("hex", "rgb"),
  func = stats::median
)
}
\arguments{
\item{stimuli}{list of stimuli}

\item{width, height}{dimensions of the patch in pixels, if <=1, interpreted as proportions of width or height}

\item{x_off, y_off}{offset in pixels or proportion (<1)}

\item{color}{The type of color to return (hex, rgb)}

\item{func}{The function to apply to an array of L*ab color values to determine the central colour (defaults to median, but mean, min, or max can also be useful)}
}
\value{
a vector of hex or rgba color values
}
\description{
Get the median (or mean or user-defined function) colour value of a specified patch of pixels on an image. This is useful for matching background colours.
}
\details{
The colour values of each pixel in the patch are converted to CIE-Lab values before using the func to calculate the central tendency of the L (lightness), a (red-green axis) and b (blue-yellow axis); see \code{\link[=col2lab]{col2lab()}} and \code{\link[=lab2rgb]{lab2rgb()}} for more details.

This excludes transparent pixels, and returns "transparent" if all pixels in the patch are transparent.
}
\examples{
stimuli <- demo_stim()

# get colour from the upper left corder
patch(stimuli)

# get median colour from centre .1 width pixels
patch(stimuli, width = .1, height = .1, 
      x_off = .45, y_off = .45)

# get mean rgb colour from full image
patch(stimuli, width = 1, height = 1, 
      color = "rgb", func = mean)

}
