% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oauth.R
\name{oauth2_third_party_app}
\alias{oauth2_third_party_app}
\title{App representing the third-party app}
\usage{
oauth2_third_party_app(name = "Third-Party app")
}
\arguments{
\item{name}{Name of the third-party app}
}
\value{
webfakes app
}
\description{
The webfakes package comes with two fake apps that allow to imitate the
OAuth2.0 flow in your test cases. (See \href{https://aaronparecki.com/oauth-2-simplified/}{Aaron Parecki’s tutorial} for a good
introduction to OAuth2.0.) One app (\code{oauth2_resource_app()}) is the API
server that serves both as the resource and provides authorization.
\code{oauth2_third_party_app()} plays the role of the third-party app. They
are useful when testing or demonstrating code handling OAuth2.0
authorization, token caching, etc. in a package. The apps can be used in
your tests directly, or you could adapt one or both of them to better
mimic a particular OAuth2.0 flow.
}
\details{
Endpoints:
\itemize{
\item \code{POST /login/config} Use this endpoint to configure the client ID
and the client secret of the app, received from
\code{\link[=oauth2_resource_app]{oauth2_resource_app()}} (or another resource app). You need to
send in a JSON or URL encoded body:
\itemize{
\item \code{auth_url}, the authorization URL of the resource app.
\item \code{token_url}, the token URL of the resource app.
\item \code{client_id}, the client ID, received from the resource app.
\item \code{client_secret} the client secret, received from the resource
app.
}
\item \code{GET /login} Use this endpoint to start the login process. It
will redirect to the resource app for authorization and after the
OAuth2.0 dance to \verb{/login/redirect}.
\item \code{GET /login/redirect}, \code{POST /login/redirect} This is the
redirect URI of the third party app. (Some HTTP clients redirect
a \code{POST} to a \code{GET}, others don't, so it has both.) This endpoint
is used by the resource app, and it received the \code{code} that can
be exchanged to an access token and the \code{state} which was
generated in \verb{/login}. It contacts the resource app to get an
access token, and then stores the token in its \code{app$locals}
local variables. It fails with HTTP code 500 if it cannot obtain
an access token. On success it returns a JSON dictionary with
\code{access_token}, \code{expiry} and \code{refresh_token} (optionally) by
default. This behavior can be changed by redefining the
\code{app$redirect_hook()} function.
\item \code{GET /locals} returns the tokens that were obtained from the
resource app.
\item \code{GET /data} is an endpoint that uses the obtained token(s) to
connect to the \verb{/data} endpoint of the resource app. The \verb{/data}
endpoint of the resource app needs authorization. It responds
with the response of the resource app. It tries to refresh the
access token of the app if needed.
}

For more details see \code{vignette("oauth", package = "webfakes")}.
}
\seealso{
Other OAuth2.0 functions: 
\code{\link{oauth2_httr_login}()},
\code{\link{oauth2_login}()},
\code{\link{oauth2_resource_app}()}
}
\concept{OAuth2.0 functions}
