% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webexercises_default.R
\name{webexercises_default}
\alias{webexercises_default}
\title{Create default webexercises document}
\usage{
webexercises_default(...)
}
\arguments{
\item{...}{Additional function arguments to pass to
\code{\link[rmarkdown]{html_document}}.}
}
\value{
R Markdown output format to pass to 'render'.
}
\description{
This function wraps \code{rmarkdown::html_document} to configure
compilation to embed the default webexercises CSS and JavaScript files in
the resulting HTML.
}
\details{
Call this function as the \code{output_format} argument
  for the \code{\link[rmarkdown]{render}} function when compiling
  HTML documents from RMarkdown source.
}
\examples{
# copy the webexercises 'R Markdown' template to a temporary file
\dontrun{
my_rmd <- tempfile(fileext = ".Rmd")
rmarkdown::draft(my_rmd, "webexercises", "webexercises")

# compile it
rmarkdown::render(my_rmd, webexercises::webexercises_default())

# view the result
browseURL(sub("\\\\.Rmd$", ".html", my_rmd))
}
}
\seealso{
\code{\link[rmarkdown]{render}}, \code{\link[rmarkdown]{html_document}}
}
