% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{is.inchikey}
\alias{is.inchikey}
\title{Check if input is a valid inchikey}
\usage{
is.inchikey(x, type = c("format", "chemspider"), verbose = TRUE)
}
\arguments{
\item{x}{character; input InChIKey}

\item{type}{character; How should be checked? Either, by format (see above) ('format') or by ChemSpider ('chemspider').}

\item{verbose}{logical; print messages during processing to console?}
}
\value{
a logical
}
\description{
This function checks if a string is a valid inchikey.
Inchikey must fulfill the following criteria:
1) consist of 27 characters;
2) be all uppercase, all letters (no numbers);
3) contain two hyphens at positions 15 and 26;
4) 24th character (flag character) be 'S' (Standard InChI) or 'N' (non-standard)
5) 25th character (version character) must be 'A' (currently).
}
\note{
This function can handle only one inchikey string.
}
\examples{
is.inchikey('BQJCRHHNABKAKU-KBQPJGBKSA-N')
is.inchikey('BQJCRHHNABKAKU-KBQPJGBKSA')
is.inchikey('BQJCRHHNABKAKU-KBQPJGBKSA-5')
is.inchikey('BQJCRHHNABKAKU-KBQPJGBKSA-n')
is.inchikey('BQJCRHHNABKAKU/KBQPJGBKSA/N')
is.inchikey('BQJCRHHNABKAKU-KBQPJGBKXA-N')
is.inchikey('BQJCRHHNABKAKU-KBQPJGBKSB-N')
}
\references{
Heller, Stephen R., et al. "InChI, the IUPAC International Chemical Identifier." Journal of Cheminformatics 7.1 (2015): 23.
}
\author{
Eduard Szoecs, \email{eduardszoecs@gmail.com}
}
