% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/physprop.R
\name{pp_query}
\alias{pp_query}
\title{Query SRC PHYSPROP Database}
\usage{
pp_query(cas, verbose = TRUE)
}
\arguments{
\item{cas}{character; A CAS number to query.}

\item{verbose}{logical; print message during processing to console?}
}
\value{
A list of lists with 5 entries: cas (CAS-Number), cname (Chemical Name),
mw (Molecular weigth), prop (Properties) and source url.
prop is a data.frame, with variables, value, unit, temp, type (see note) and ref (see note).
}
\description{
Query SRCs PHYSPROP Database. The PHYSPROP database contains chemical structures,
names and physical properties for over 41,000 chemicals.
Physical properties collected from a wide variety of sources include experimental,
extrapolated and estimated values. For more information
see \url{http://www.srcinc.com/what-we-do/environmental/scientific-databases.html#physprop}.
}
\note{
Abbreviations in the 'Type' field: EXP = Experimental Data,
EST = Estimated Data, EXT = Extrapolated Data.
Please respect the terms of use: \url{http://www.srcinc.com/terms-of-use.html}.
}
\examples{
\dontrun{
pp_query('50-00-0')
out <- pp_query(c('50-00-0', '79622-59-6', 'xxxxx'))
out

# extract lop-P
sapply(out, function(y){
 if (length(y) == 1 && is.na(y))
   return(NA)
 y$prop$value[y$prop$variable == 'Log P (octanol-water)']
 })
}
}
\author{
Eduard Szoecs, \email{eduardszoecs@gmail.com}
}
