% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ppdb.R
\name{ppdb_query}
\alias{ppdb_query}
\title{Query the ppdb for information}
\usage{
ppdb_query(cas, verbose = TRUE)
}
\arguments{
\item{cas}{character; CAS number to query.}

\item{verbose}{logical; print message during processing to console?}
}
\value{
A list of 10 data.frames : ec_regulation, approved_in, general, parents, fate,
deg, soil, metab, etox and names.




See also \url{http://sitem.herts.ac.uk/aeru/iupac/docs/Background_and_Support.pdf} for more information on the data
}
\description{
This function queries the PPDB \url{http://sitem.herts.ac.uk/aeru/iupac/search.htm} for information.
}
\examples{
\dontrun{
# might fail if Server is not available
gly <- ppdb_query('1071-83-6')
gly$approved_in

# handle multiple CAS
 cas <- c('1071-83-6', '50-00-0')
}
}
\author{
Eduard Szoecs, \email{eduardszoecs@gmail.com}
}

