% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data_drill.R
\encoding{UTF-8}
\name{get_data_drill}
\alias{get_data_drill}
\title{Get DataDrill Weather Data From SILO}
\usage{
get_data_drill(
  longitude,
  latitude,
  start_date,
  end_date = Sys.Date(),
  values = "all",
  api_key = get_key(service = "SILO")
)
}
\arguments{
\item{longitude}{A single \code{numeric} value  representing the longitude of the
point-of-interest to the hundredths (\emph{e.g.}, 0.05) of a degree.}

\item{latitude}{A single \code{numeric} value representing the latitude of the
point-of-interest to the hundredths (\emph{e.g.}., 0.05) of a degree.}

\item{start_date}{A \code{character} string or \code{Date} object representing the
beginning of the range to query in the format \dQuote{yyyy-mm-dd}
(ISO8601).  Data returned is inclusive of this date.}

\item{end_date}{A \code{character} string or \code{Date} object representing the end of
the range query in the format  \dQuote{yyyy-mm-dd} (ISO8601).  Data
returned is inclusive of this date.  Defaults to the current system date.}

\item{values}{A \code{character} string with the type of weather data to
return.  See \strong{Available Values} for a full list of valid values.
Defaults to \code{all} with all available values being returned.}

\item{api_key}{A \code{character} string containing your \acronym{API} key,
an e-mail address, for the request.  Defaults to automatically detecting
your key from your local .Renviron, .Rprofile or similar.  Alternatively,
you may directly provide your key as a string here.  If nothing is
provided, you will be prompted on how to set up your \R session so that it
is auto-detected.}
}
\value{
a \code{\link[data.table:data.table]{data.table::data.table()}} with the weather data queried with
the weather variables in alphabetical order. The first eight columns will
always be:
\itemize{
\item \code{longitude},
\item \code{latitude},
\item \code{elev_m} (elevation in metres),
\item \code{date} (ISO8601 format, YYYYMMDD),
\item \code{year},
\item \code{month},
\item \code{day},
\item \code{extracted} (the date on which the query was made)
}
}
\description{
Fetch nicely formatted weather data from the \acronym{SILO} \acronym{API} of
spatially interpolated weather data (DataDrill).  The daily climate
surfaces have been derived either by splining or kriging the observational
data.  The returned values contain \dQuote{source} columns, which denote
how the observations were derived.  The grid spans 112° to 154°, -10° to
-44° with resolution 0.05° latitude by 0.05° longitude (approximately 5 km
× 5 km).
}
\section{Column Name Details}{
Column names are converted from the default returns of the API to be
snake_case formatted and where appropriate, the names of the values that
are analogous between \acronym{SILO} and \acronym{DPIRD} data are named
using the same name for ease of interoperability, \emph{e.g.}, using
\code{rbind()} to create a \code{data.table} that contains data from both APIs.
}

\section{Available Values}{


\describe{
\item{all}{Which will return all of the following values}
\item{rain (mm)}{Rainfall}
\item{max_temp (degrees C)}{Maximum temperature}
\item{min_temp (degrees C)}{Minimum temperature}
\item{vp (hPa)}{Vapour pressure}
\item{vp_deficit (hPa)}{Vapour pressure deficit}
\item{evap_pan (mm)}{Class A pan evaporation}
\item{evap_syn (mm)}{Synthetic
\ifelse{html}{\out{estimate<sup>1</sup>}}{estimate\eqn{^1}}}
\item{evap_comb (mm)}{Combination (synthetic estimate pre-1970, class A pan
1970 onwards)}
\item{evap_morton_lake (mm)}{Morton's shallow lake evaporation}
\item{radiation (Mj/\ifelse{html}{\out{m<sup>2</sup>}}{m\eqn{^2}})}{Solar
exposure, consisting of both direct and diffuse components}
\item{rh_tmax (\%)}{Relative humidity at the time of maximum temperature}
\item{rh_tmin (\%)}{Relative humidity at the time of minimum temperature}
\item{et_short_crop (mm)}{
\ifelse{html}{\out{FAO56<sup>4</sup>}}{FAO56\eqn{^4}} short crop}
\item{et_tall_crop (mm)}{
\ifelse{html}{\out{ASCE<sup>5</sup>}}{ASCE\eqn{^5}} tall
\ifelse{html}{\out{crop<sup>6</sup>}}{crop\eqn{^6}}}
\item{et_morton_actual (mm)}{Morton's areal actual evapotranspiration}
\item{et_morton_potential (mm)}{Morton's point potential evapotranspiration}
\item{et_morton_wet (mm)}{Morton's wet-environment areal potential
evapotranspiration over land}
\item{mslp (hPa)}{Mean sea level pressure}
}
}

\section{Value information}{


Solar radiation: total incoming downward shortwave radiation on a horizontal
surface, derived from estimates of cloud oktas and sunshine
\ifelse{html}{\out{duration<sup>3</sup>}}{duration\eqn{^3}}.

Relative humidity: calculated using the vapour pressure measured at 9am, and
the saturation vapour pressure computed using either the maximum or minimum
\ifelse{html}{\out{temperature<sup>6</sup>}}{temperature\eqn{^6}}.

Evaporation and evapotranspiration: an overview of the variables provided by
\acronym{SILO} is available here,
\url{https://data.longpaddock.qld.gov.au/static/publications/Evapotranspiration_overview.pdf}.
}

\section{Data codes}{

Data codes
Where possible (depending on the file format), the data are supplied with
codes indicating how each datum was obtained.

\describe{
\item{0}{Official observation as supplied by the Bureau of Meteorology}
\item{15}{Deaccumulated rainfall (original observation was recorded
over a period exceeding the standard 24 hour observation period)}
\item{25}{Interpolated from daily observations for that date}
\item{26}{Synthetic Class A pan evaporation, calculated from
temperatures, radiation and vapour pressure}
\item{35}{Interpolated from daily observations using an anomaly
interpolation method}
\item{75}{Interpolated from the long term averages of daily
observations for that day of year}
}
}

\examples{
\dontrun{
# requires an API key as your email address
# Source data from latitude and longitude coordinates (gridded data) for
# max and minimum temperature and rainfall for Southwood, QLD.
wd <- get_data_drill(
  latitude = -27.85,
  longitude = 150.05,
  start_date = "20221001",
  end_date = "20221201",
  values = c("max_temp", "min_temp", "rain"),
  api_key = "your_api_key"
)
}

}
\references{
\enumerate{
\item Rayner, D. (2005). Australian synthetic daily Class A pan evaporation.
Technical Report December 2005, Queensland Department of Natural Resources
and Mines, Indooroopilly, Qld., Australia, 40 pp.
\item Morton, F. I. (1983). Operational estimates of areal evapotranspiration
and their significance to the science and practice of hydrology, \emph{Journal
of Hydrology}, Volume 66, 1-76.
\item Zajaczkowski, J., Wong, K., & Carter, J. (2013). Improved historical
solar radiation gridded data for Australia, \emph{Environmental Modelling &
Software}, Volume 49, 64–77. DOI: \doi{10.1016/j.envsoft.2013.06.013}.
\item Food and Agriculture Organization of the United Nations,
Irrigation and drainage paper 56: Crop evapotranspiration - Guidelines for
computing crop water requirements, 1998.
\item ASCE’s Standardized Reference Evapotranspiration Equation, proceedings of
the National Irrigation Symposium, Phoenix, Arizona, 2000.
\item For further details refer to Jeffrey, S.J., Carter, J.O., Moodie, K.B. and
Beswick, A.R. (2001). Using spatial interpolation to construct a
comprehensive archive of Australian climate data, \emph{Environmental Modelling
and Software}, Volume 16/4, 309-330. DOI:
\doi{10.1016/S1364-8152(01)00008-1}.
}
}
\seealso{
Other SILO: 
\code{\link{find_nearby_stations}()},
\code{\link{find_stations_in}()},
\code{\link{get_data_drill_apsim}()},
\code{\link{get_patched_point}()},
\code{\link{get_patched_point_apsim}()},
\code{\link{get_stations_metadata}()},
\code{\link{silo_daily_values}}

Other data fetching: 
\code{\link{get_ag_bulletin}()},
\code{\link{get_coastal_forecast}()},
\code{\link{get_data_drill_apsim}()},
\code{\link{get_dpird_apsim}()},
\code{\link{get_dpird_extremes}()},
\code{\link{get_dpird_minute}()},
\code{\link{get_dpird_summaries}()},
\code{\link{get_patched_point}()},
\code{\link{get_patched_point_apsim}()},
\code{\link{get_precis_forecast}()},
\code{\link{get_radar_imagery}()},
\code{\link{get_satellite_imagery}()}
}
\author{
Rodrigo Pires, \email{rodrigo.pires@dpird.wa.gov.au}, and Adam H.
Sparks, \email{adamhsparks@gmail.com}
}
\concept{SILO}
\concept{data fetching}
