% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Selection.R
\name{ARMA.selec}
\alias{ARMA.selec}
\title{Selection of ARMA models}
\usage{
ARMA.selec(data, P, Q, c = 2)
}
\arguments{
\item{data}{Univariate time series.}

\item{P}{Integer for the maximum lag order of autoregressive component.}

\item{Q}{Integer for the maximum lag order of moving-average component.}

\item{c}{Real number >1 needed to compute Hannan-Quinn information criterion.}
}
\value{
A list of the different criteria, each item contains the matrix of the 
 computed value for the different model and the selected order with this criterion 
 (corresponding to the minimum value in the previous matrix).
}
\description{
Identifies the orders p and q of an ARMA model according to several
 information criteria.
}
\details{
The fitted model which is favored is the one corresponding to the
 minimum value of the criterion. The most popular criterion is the Akaike information
 criterion (\code{AIC}). This was designed to be an approximately unbiased
 estimator of a fitted model. For small sample or when  the number of fitted
 parameters is large, it is more appropriate to  manipulate a corrected AIC
 version (\code{AICc}) which is more nearly unbiased. But these two criteria
 are inconsistent for model orders selection. If you want to use a consistent
 criterion, it is possible to take the Bayesian information criterion
 (\code{BIC}) or the Hannan-Quinn information  criteria (\code{HQ}).

 For the weak ARMA, i.e under the assumption that the errors are uncorrelated
 but not necessarily independant, modified criteria has been adapted :
 \code{AICm}, \code{AICcm}, \code{BICm}, \code{HQm}.

 The criteria definitions are the following :

 \deqn{AIC = n\log(\sigma^{2}) + 2(p + q)}

 \deqn{AICm = n\log(\sigma^{2}) + \frac{Tr(IJ^{-1})}{\sigma^2}}

 \deqn{AICc = n\log(\sigma^{2}) + n + \frac{n}{(n-(p + q + 1))} 2(p + q)}

 \deqn{AICcm = n\log(\sigma^{2}) + \frac{n^{2}}{(n-(p + q + 1))}  + \frac{n}{(2(n-(p + q + 1)))} \frac{Tr(IJ^{-1})}{\sigma^2}}

 \deqn{BIC = n\log(\sigma^{2}) + (p + q)log(n)}

 \deqn{BICm = n\log(\sigma^{2}) + \frac{1}{2} \frac{Tr(IJ^{-1})}{\sigma^2}log(n)}

 \deqn{HQ = n\log(\sigma^{2}) + 2c(p + q)log(log(n))}

 \deqn{HQm = n\log(\sigma^{2}) + c\frac{Tr(IJ^{-1})}{\sigma^2}log(log(n))}
}
\examples{
\donttest{ARMA.selec (CAC40return.sq, P = 3, Q = 3)}

}
\references{
Boubacar Maïnassara, Y. 2012, Selection of weak VARMA models by
 modified Akaike's information  criteria, \emph{Journal of Time Series
 Analysis}, vol. 33, no. 1, pp. 121-130

Boubacar Maïnassara, Y. and Kokonendji, C. C. 2016, Modified Schwarz
 and Hannan-Quin information criteria for weak VARMA models, \emph{Stat
 Inference Stoch Process}, vol. 19, no. 2, pp. 199-217
}
